<?php
	// flat file database engine
	// by e. wenners - www.chaozz.nl
	
	// settings
	$delimiter = "|$|";
	
	Function DeleteRecord($db_table, $find_condition) {
		global $delimiter;
		global $db_location;
		
		// deletes a record with the given conditions
		// example: DeleteRecord("user", "id+=2");
		
		$db_file = $db_location.$db_table.".tsv"; 	// open the table for reading and writing
        @unlink ($db_file."_");					// it might exist if a previous deletion failed
		rename ($db_file, $db_file."_");		// lock the table
		
		$old_table = fopen($db_file."_",'r'); 	// open the locked table
		$new_table = fopen($db_file,'w'); 		// open the new table

		// lets first transfer the first line, which holds the fields
		$record = fgets($old_table);
		$field  = explode($delimiter, $record);
		fwrite($new_table, $record);
		
		if ($find_condition != '*') { // are there conditions?
			$condition = explode(",", $find_condition);
			$num_condition = 0;
			foreach ($condition as $current_condition) {
				$num_condition += 1;
				list($condition_field[$num_condition], $condition_value[$num_condition]) = explode("=", $current_condition);
				$compare_method[$num_condition] = substr($condition_field[$num_condition], -1);
				$condition_field[$num_condition] = substr($condition_field[$num_condition], 0, strlen($condition_field[$num_condition]) -1);
			}
		}
		
		while ( $record = fgets($old_table) ) {
			$record_values = explode($delimiter, $record);
			$delete_record = FALSE;
			$num_compare = 0;
			
			if ($find_condition != '*') {			// there are conditions
				for ($i = 1; $i <= $num_condition; $i++) {
					$record_value = trim($record_values[FindField($db_table, $condition_field[$i])]);
					if ($compare_method[$i] == "+" && $record_value == $condition_value[$i]) { $num_compare += 1; }
					if ($compare_method[$i] == "-" && $record_value != $condition_value[$i]) { $num_compare += 1;; }
					if ($compare_method[$i] == "~" && strrpos($record_value, $condition_value[$i]) !== FALSE) { $num_compare += 1;; }
					if ($compare_method[$i] == "<" && intval($record_value) < intval($condition_value[$i])) { $num_compare += 1; }
					if ($compare_method[$i] == ">" && intval($record_value) > intval($condition_value[$i])) { $num_compare += 1; }
				}
				if ($num_compare == $num_condition) { $delete_record = TRUE; }
			}
			else { $delete_record = TRUE; }	// no conditions and no specific id			
			
			if (!$delete_record) {
				fwrite($new_table, $record);
			}
		}
		fclose($old_table);
		fclose($new_table);
		unlink ($db_file."_");			// delete lock table
		return TRUE;
	}
	
	Function UpdateRecord($db_table, $db_values) {
		global $delimiter;
		global $db_location;
		
		$value = explode($delimiter, $db_values);
		DeleteRecord($db_table, "id+=". $value[0]);
		AddRecord($db_table, $db_values);
	}
		
	Function AddRecord($db_table, $db_values) {
		global $delimiter;
		global $db_location;

		// can add a new record
		// example: AddRecord("user", "AUTO|Y|".$username.$delimiter.md5($userpass)."|N|".$email)

		
		$db_file = $db_location.$db_table.".tsv"; // open the table for reading and writing
		
		if (trim($value[0]) == "AUTO") {
			$db_handle = fopen ($db_file, "r+"); // cursor in beginning of file
		}
		else {
			$db_handle = fopen ($db_file, "a+"); // cursor at the end of the file
		}
		if (!$db_handle) { return FALSE; }
		
		$record = fgets($db_handle); // first line lists all table fields
		$value = explode($delimiter, $db_values);
		
		if (trim($value[0]) == "AUTO") { // if the first field is an auto incremented id, then find the highest ID and add +1
			$auto_id = 0;
			while ( $record = fgets($db_handle) ) {
				$current_record = explode($delimiter, $record);
				if ($current_record[0] > $auto_id) { $auto_id = $current_record[0]; }
			}
			$value[0] = $auto_id +1;
		}
		
		$new_record = implode($delimiter, $value);
		
		fwrite($db_handle, $new_record."\r\n");
		fclose($db_handle); // close table
		return $value[0];
	}
	
	Function OpenRecord($db_table, $select_fields, $find_condition, $sort_order='', $auto_join='false', $limit='') {
		global $delimiter;
		global $db_location;

		// open records that suit the conditions and only return the requested fields.
		//
		// syntax:
		// $db_table : name of the text file without extension
		// $select_fields : {fieldx,fieldy,fieldz} or {*}
		//
		// $find_conditions :  (default = '*')
		// field+=value > field must be equal to value
		// field-=value > field must not be equal to value
		// field~=value > field must contain the substring value
		//
		// OPTIONAL: $sort_order: {field type direction}
		// sort by fieldx and sort it as a number or as a string either ascending or descending
		//
		// OPTIONAL: $auto_join: {true/false}
		// automaticly join tables so ID fields will contain text
		//
		// OPTIONAL: $limit: empty = all records. any number will return that number of records
		//
		// example: OpenRecord("bug", "*", "status_id+=0", "id num desc", "true","10")
		// shows 10 bugs that have the status "unconfirmed" and start with the newest

		$db_table		= trim($db_table);
		$find_condition	= trim($find_condition);
		$sort_order		= trim($sort_order);
		
		$db_file = $db_location.$db_table.".tsv"; // open the table for reading and writing
		$db_handle = fopen ($db_file, "r+");
		
		if (!$db_handle) {
			return FALSE; // error opening table
		}
		
		$record = fgets($db_handle); 			// first line lists all table fields
		$field = explode($delimiter, $record);		// all fields in an array
		
		if ($find_condition != '*') { // are there conditions?
			$condition = explode(",", $find_condition);
			$num_condition = 0;
			foreach ($condition as $current_condition) {
				$num_condition += 1;
				list($condition_field[$num_condition], $condition_value[$num_condition]) = explode("=", $current_condition);
				$compare_method[$num_condition] = substr($condition_field[$num_condition], -1);
				$condition_field[$num_condition] = substr($condition_field[$num_condition], 0, strlen($condition_field[$num_condition]) -1);
			}
		}
		
		if ($sort_order != '') { // do we need to do some sorting?
			list($sort_field, $sort_type, $sort_direction) = explode(" ", $sort_order);
		}
		
		$search_result = "";				// if no records are found this will prevent an error
		$record_counter = -1;				// no records.. yet
		
		while ( $record = fgets($db_handle) ) {
			$record_values = explode($delimiter, $record);	// process the record
			$add_record = FALSE;
			$num_compare = 0;
			
			if ($find_condition != '*') {			// there are conditions
				for ($i = 1; $i <= $num_condition; $i++) {
					$record_value = trim($record_values[FindField($db_table, $condition_field[$i])]);
					if ($compare_method[$i] == "+" && $record_value == $condition_value[$i]) { $num_compare += 1; }
					if ($compare_method[$i] == "-" && $record_value != $condition_value[$i]) { $num_compare += 1;; }
					if ($compare_method[$i] == "~" && strrpos($record_value, $condition_value[$i]) !== FALSE) { $num_compare += 1;; }
					if ($compare_method[$i] == "<" && $record_value < $condition_value[$i]) { $num_compare += 1; }
					if ($compare_method[$i] == ">" && $record_value > $condition_value[$i]) { $num_compare += 1; }
				}
				if ($num_compare == $num_condition) { $add_record = TRUE; }
			}
			else { $add_record = TRUE; }	// no conditions and no specific id
			
			if ($add_record) {
				$record_counter += 1;			// add a record
				$search_result[$record_counter] = $record;
				if ($sort_order != '') {
					$sort_array[$record_counter] = $record_values[FindField($db_table, $sort_field)];
				}
			}
		}	

		if ($record_counter == -1) { return false; }
		
		if ($auto_join == 'true') {
			foreach ($field as $fieldkey => $_field) { 
				$_field = trim($_field);
				if (substr($_field, -3) == "_id") {	// an _ID field linked to another table
					foreach ($search_result as $searchkey => $_search_result) {
						$value = explode($delimiter, $_search_result);		// divide the record values
						$table = explode ("_", $_field);			// and id field syntax is tablename_id
						$value[$fieldkey] = FindValue($table[0], $value[$fieldkey], "name");	// replace the id by the name field
						$search_result[$searchkey] = implode($delimiter, $value);	// merge it back into a record
					}
				}	
			}
		}	
		
		if ($sort_order != '') { // let's sort the record array according to the sort_array
			if ($sort_direction ==  "asc" && $sort_type == "str") 	{ array_multisort($sort_array, SORT_ASC, SORT_STRING, $search_result); }
			if ($sort_direction ==  "asc" && $sort_type == "num") 	{ array_multisort($sort_array, SORT_ASC, SORT_NUMERIC, $search_result); }
			if ($sort_direction ==  "desc" && $sort_type == "str") 	{ array_multisort($sort_array, SORT_DESC, SORT_STRING, $search_result); }
			if ($sort_direction ==  "desc" && $sort_type == "num") 	{ array_multisort($sort_array, SORT_DESC, SORT_NUMERIC, $search_result); }
		}
		
		if ($select_fields != '*') { // we don't return all fields, just the ones in $select_fields
			$selection = explode(",", $select_fields);
			foreach ($search_result as $result_key => $record) {
				$field = explode($delimiter, $record);
				foreach ($selection as $key => $sel_field) {
					$new_record[$key] = $field[FindField($db_table, $sel_field)];
				}
				$search_result[$result_key] = implode($delimiter, $new_record);
			}
		}
		
		fclose($db_handle); // close table
		
		// now trim all values in the recordset and maybe apply a limit.
		$copy_result = $search_result;
		unset ($search_result);
		foreach ($copy_result as $result_key=>$trim_result) {
			$value = explode($delimiter, $trim_result);
			foreach ($value as $trim_key => $trim_value) {
				$value[$trim_key] = trim($trim_value);
			}
			$search_result[$result_key] = implode($delimiter, $value);
			if ($result_key+1 == $limit) { break; }
		}
		return $search_result;
	}

	Function FindField($db_table, $find_field) {
		global $delimiter;
		global $db_location;

		// find a  field in a table and return it's position (0, 1, 2.. etc). 
		// ONLY USED INTERNALLY BY db_engine.php!!

		$db_table		= trim($db_table);
		$find_field		= trim($find_field);
		
		
		$db_file = $db_location.$db_table.".tsv"; // open the table for reading and writing
		$db_handle = fopen ($db_file, "r+");

		if (!$db_handle) {
			return FALSE; 					// error opening table
		}
		$record = fgets($db_handle); 			// first line lists all table fields
		$field = explode($delimiter, $record);		// all fields in an array
		$counter = -1;						// nothing found yet
		
		foreach ($field as $compare_field) {	// loop through the fields
		    $counter += 1;
			if (trim($compare_field) == trim($find_field)) { $search_result = $counter; } // if we have a match, remember it's position
		}
		
		fclose($db_handle); 					// close table
		return $search_result;				// return result
	}		
	
	Function FindValue($db_table, $find_record_id, $find_field) {
		global $delimiter;
		global $db_location;

		// find a  value in a record by it's recordID. 
		// ONLY USED INTERNALLY by db_engine.php!!

		$db_table		= trim($db_table);
		$find_record_id	= trim($find_record_id);
		$find_field		= trim($find_field);
	
		$db_file = $db_location.$db_table.".tsv"; // open the table for reading and writing
		$db_handle = fopen ($db_file, "r+");
		
		if (!$db_handle) {
			return FALSE; // error opening table
		}
		$record = fgets($db_handle); 		// first line lists all table fields
		$field = explode($delimiter, $record);		// all fields in an array
		$search_result = "";				// if no records are found this will prevent an error
		
		while ( $record = fgets($db_handle) ) {
			$current_record = explode($delimiter, $record);
			if (trim($current_record[0]) == trim($find_record_id)) { 
				// we have the correct record, now find the right field
				$search_result = $current_record[FindField($db_table, $find_field)];
			}
		}	
		fclose($db_handle); // close table
		return $search_result;
	}		
	Function FindFieldName($db_table, $find_field) {
		global $delimiter;
		global $db_location;

		// find a  fieldname
		// ONLY USED INTERNALLY by db_engine.php!!

		$db_table		= trim($db_table);
		$find_field		= trim($find_field);
	
		$db_file = $db_location.$db_table.".tsv"; // open the table for reading and writing
		$db_handle = fopen ($db_file, "r+");
		
		if (!$db_handle) {
			return FALSE; // error opening table
		}
		$record = fgets($db_handle); 		// first line lists all table fields
		$field = explode($delimiter, $record);		// all fields in an array
		$search_result = "";				// if no records are found this will prevent an error
		
		foreach ($field as $key => $fieldname) {
			if ($key == $find_field) {
				$search_result = $fieldname;
			}
		}	
		fclose($db_handle); // close table
		return $search_result;
	}		
?>