<?php
//==============================================================
// Simple User Session / Managment Library for Chaozdb
// V beta 0.4 - Chaozdb 
//==============================================================
// Installation:
// * include cdb_log.php in your php file.
// * put the user.tsv file in your chaozdb folder
// * use the functions below:
//   -> register_user()
//   -> delete_user()
//   -> login_user()
//   - logout_user()
//==============================================================
// User names and pwds are stored hashed
//==============================================================
// Usage:
// Via the php SESSION the following variables are maintained
// * status : Indicating status
// * user : user name (cleared)
// * user_roup : the group id
// * Logged : boolean for logged or not


// ouverture de session
session_start();

// user Registering ============================================
// $user  : Username REGULAR TEXT STRING
// $pass1 : Password REGULAR TEXT STRING
// $pass1 : Password REGULAR TEXT STRING, confirmed

function register_user($user,$pass1,$pass2){
  $error='';
  $delimiter = "|$|";


// User validation
  if ($user==''|$pass1==''|pass2=='') $error='All fileds must be filled.';
  if ($pass1!=$pass2) $error='Passwords are different.';
  if (strlen($pass1)<8) $error='Password shall contain at least 8 characters.';
  if (!filter_var($user,FILTER_VALIDATE_REGEXP, array('options' => array('regexp' => "/^[a-zA-Z0-9]+$/")))) $error='User name may only include A-Z/a-z/0-9 characters.';
  if (!filter_var($pass1,FILTER_VALIDATE_REGEXP, array('options' => array('regexp' => "/^[a-zA-Z0-9]+$/")))) $error='Password may only include A-Z/a-z/0-9 characters.';
  if (!filter_var($pass2,FILTER_VALIDATE_REGEXP, array('options' => array('regexp' => "/^[a-zA-Z0-9]+$/")))) $error='Password may only include A-Z/a-z/0-9 characters.';

// Let's go if everything's Ok !
  if ($error==''){
    $md_user=trim(md5($user));
    $record = OpenRecord("user", "id,name,group_id", "name+=$md_user", "name str asc", "true","");
    if (!$record) {
      $value[0] = "AUTO";				
      $value[1] = $md_user;				
      $value[2] = md5($pass1);		
      $value[3] = "1";				
      $record = implode($delimiter, $value);
      $new_id = AddRecord("user", $record);
      $error='User Created';
    }
    else {
    $error='User already exists!';
    }
  }

return $error;
}

// user Delete ============================================
// $user  : Username REGULAR TEXT STRING
// $pass1 : Password REGULAR TEXT STRING

function delete_user($user,$pass1) {
    $error='';
    $md_user=trim(md5($user));
    $record = OpenRecord("user", "id,password,group_id", "name+=$md_user", "name str asc", "true","");
    if (!$record) {
      $error='No user corresponding';
    }
    else {
      $delimiter="|$|";
      foreach ($record as $current_record) {
      $value=explode($delimiter,$current_record);
      if ( trim(md5($pass1))!=trim($value[1]) ) {
        $error='Wrong Password!';
      }
      else {
        $error = DeleteRecord("user", "name+=$md_user");
        echo "Deletion";
      }
      }
    }
    return $error;
}

// user Login ============================================
// $user  : Username REGULAR TEXT STRING
// $pass1 : Password REGULAR TEXT STRING

function login_user($user,$pass1) {
    $error='';
    $md_user=trim(md5($user));
    $record = OpenRecord("user", "id,password,group_id", "name+=$md_user", "name str asc", "true","");
    if (!$record) {
      $error='No user corresponding';
    }
    else {
      $delimiter="|$|";
      foreach ($record as $current_record) {
      $value=explode($delimiter,$current_record);
      if ( trim(md5($pass1))!=trim($value[1]) ) {
        $error='Wrong Password!';
      }
      else {
        $_SESSION['monk']="logged";
        $_SESSION['user']=$user;
        $_SESSION['user_group']=$value[2];
        $_SESSION['logged']='1';

      }
      }
    }
    return $error;
}
// user Logout ============================================

function logout_user() {
        unset($_SESSION['monk']);
        unset($_SESSION['user']);
        unset($_SESSION['user_group']);
        unset($_SESSION['logged']);
        return "user loged out";
}
?>
